﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS;
using KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary;

namespace OpenAPI_App_Manager
{
    public partial class frmAdvancedSearch : Form
    {
        private AdvancedSearchSettings settings;
        public AdvancedSearchSettings Settings
        {
            get
            {
                return settings;
            }
        }

        public frmAdvancedSearch(AdvancedSearchSettings AdvancedSearch)
        {
            InitializeComponent();

            
            this.settings = AdvancedSearch;

            checkBoxProductName.Checked = this.settings.ProductName;
            checkBoxFV.Checked = this.settings.FunctionVersion;
            checkBoxApp.Checked = this.settings.Application;
            textBoxApp.Text = this.settings.ApplicationName;
            textBoxProductName.Text = this.settings.ProductNameText;
            comboBoxFVType.SelectedIndex = comboBoxFVType.FindString(this.settings.FunctionVersionAppType);

            if (comboBoxFVType.SelectedIndex == -1)
                comboBoxFVType.SelectedIndex = comboBoxFVType.FindString("Setup");

            comboBoxFVVer.SelectedIndex = comboBoxFVVer.FindString(this.settings.FunctionVersionAppVersion);
            if (comboBoxFVVer.SelectedIndex == -1)
                comboBoxFVVer.SelectedIndex = comboBoxFVVer.FindString("1.0");

            comboBoxFVVer1.SelectedIndex = comboBoxFVVer1.FindString(this.settings.FunctionVersionAppVersion1);
            if (comboBoxFVVer1.SelectedIndex == -1)
                comboBoxFVVer1.SelectedIndex = comboBoxFVVer1.FindString("1.0");

            //Set FunctionVersionOperator value for search
            comboBoxFVOperator.SelectedIndex = comboBoxFVOperator.FindString(this.settings.FunctionVersionOperator);
            if (comboBoxFVOperator.SelectedIndex == -1)
                comboBoxFVOperator.SelectedIndex = comboBoxFVVer1.FindString("Has");

            checkBoxSSL.Checked = this.settings.SSLSetting;
            comboBoxSSL.SelectedIndex = comboBoxSSL.FindString(this.settings.SSLText);

            if (comboBoxSSL.SelectedIndex == -1)
                comboBoxSSL.SelectedIndex = comboBoxSSL.FindString("True");

            // Set color value for search
            checkBoxColor.Checked = this.settings.ColorSetting;
            comboBoxColor.SelectedIndex = comboBoxColor.FindString(this.settings.ColorText);

            if (comboBoxColor.SelectedIndex == -1)
                comboBoxColor.SelectedIndex = comboBoxColor.FindString("Monochrome");

        }

        private void checkBoxProductName_CheckedChanged(object sender, EventArgs e)
        {
            panelProductName.Enabled = checkBoxProductName.Checked;
        }

        private void checkBoxFV_CheckedChanged(object sender, EventArgs e)
        {
                panelFV.Enabled = checkBoxFV.Checked;
                panelFVOperator.Enabled = checkBoxFV.Checked;
                FVLabel.Enabled = checkBoxFV.Checked;
        }

        private void checkBoxApp_CheckedChanged(object sender, EventArgs e)
        {
            panelApp.Enabled = checkBoxApp.Checked;
        }

        private void comboBoxFVType_SelectedIndexChanged(object sender, EventArgs e)
        {
            // The following set of codes automatically populates the list with the available versions 
            // supported by the SDK library in the Advanced Search Function version list.

            string szLastFV = comboBoxFVVer.Text;
            comboBoxFVVer.Items.Clear();
           
            string[] szVers;
            string szVern;
            switch (comboBoxFVType.Text)
            {                    
                case "Scan":                    
                    for (int i = 1; i < Enum.GetValues(typeof(ScanTypeDFunctionVersionType)).Length; i++)
                    {
                        szVern = System.Enum.GetName(typeof(ScanTypeDFunctionVersionType), i);                        
                        comboBoxFVVer.Items.Add(ReplaceStringToValue(szVern));
                        comboBoxFVVer1.Items.Add(ReplaceStringToValue(szVern));
                    }
                    break;

                case "PullPrint":
                    for (int i = 1; i < Enum.GetValues(typeof(PullFunctionVersionType)).Length; i++)
                    {
                        szVern = System.Enum.GetName(typeof(PullFunctionVersionType), i);
                        comboBoxFVVer.Items.Add(ReplaceStringToValue(szVern));
                        comboBoxFVVer1.Items.Add(ReplaceStringToValue(szVern));
                    }
                    break;

                case "JobManagement":
                    // Currently its not possible to automatically read JobManagement version from SDK Library
                    // So hardcoding the list.
                    szVers = new string[] { "1.0", "3.5", "3.6" };
                    foreach (string szVer in szVers)
                        comboBoxFVVer.Items.Add(szVer);
                    break;

                case "Authentication":
                    for (int i = 1; i < Enum.GetValues(typeof(AuthFunctionVersionType)).Length; i++)
                    {
                        szVern = System.Enum.GetName(typeof(AuthFunctionVersionType), i);
                        comboBoxFVVer.Items.Add(ReplaceStringToValue(szVern));
                        comboBoxFVVer1.Items.Add(ReplaceStringToValue(szVern));
                    }
                    break;

                case "Setup":
                    for (int i = 1; i < Enum.GetValues(typeof(SetupFunctionVersionType)).Length; i++)
                    {
                        szVern = System.Enum.GetName(typeof(SetupFunctionVersionType), i);
                        comboBoxFVVer.Items.Add(ReplaceStringToValue(szVern));
                        comboBoxFVVer1.Items.Add(ReplaceStringToValue(szVern));
                    }
                    break;


                case "ScanBrowser":
                    for (int i = 1; i < Enum.GetValues(typeof(ScanBrowserFunctionVersionType)).Length; i++)
                    {
                        szVern = System.Enum.GetName(typeof(ScanBrowserFunctionVersionType), i);
                        comboBoxFVVer.Items.Add(ReplaceStringToValue(szVern));
                        comboBoxFVVer1.Items.Add(ReplaceStringToValue(szVern));
                    }
                    break;
                    
                case "PullPrintBrowser":
                    for (int i = 1; i < Enum.GetValues(typeof(PullBrowserFunctionVersionType)).Length; i++)
                    {
                        szVern = System.Enum.GetName(typeof(PullBrowserFunctionVersionType), i);
                        comboBoxFVVer.Items.Add(ReplaceStringToValue(szVern));
                        comboBoxFVVer1.Items.Add(ReplaceStringToValue(szVern));
                    }
                    break;

                case "AuthenticationBrowser":
                    for (int i = 1; i < Enum.GetValues(typeof(AuthBrowserFunctionVersionType)).Length; i++)
                    {
                        szVern = System.Enum.GetName(typeof(AuthBrowserFunctionVersionType), i);
                        comboBoxFVVer.Items.Add(ReplaceStringToValue(szVern));
                        comboBoxFVVer1.Items.Add(ReplaceStringToValue(szVern));
                    }
                    break;

                case "ScreenSaver":
                    for (int i = 1; i < Enum.GetValues(typeof(ScreenSaverFunctionVersionType)).Length; i++)
                    {
                        szVern = System.Enum.GetName(typeof(ScreenSaverFunctionVersionType), i);
                        comboBoxFVVer.Items.Add(ReplaceStringToValue(szVern));
                        comboBoxFVVer1.Items.Add(ReplaceStringToValue(szVern));
                    }
                    break;

                case "BrowserLauncher":
                    for (int i = 1; i < Enum.GetValues(typeof(BrowserLauncherFunctionVersionType)).Length; i++)
                    {
                        szVern = System.Enum.GetName(typeof(BrowserLauncherFunctionVersionType), i);
                        comboBoxFVVer.Items.Add(ReplaceStringToValue(szVern));
                        comboBoxFVVer1.Items.Add(ReplaceStringToValue(szVern));
                    }
                    break;

                case "OtherA":
                    for (int i = 1; i < Enum.GetValues(typeof(OtherAFunctionVersionType)).Length; i++)
                    {
                        szVern = System.Enum.GetName(typeof(OtherAFunctionVersionType), i);
                        comboBoxFVVer.Items.Add(ReplaceStringToValue(szVern));
                        comboBoxFVVer1.Items.Add(ReplaceStringToValue(szVern));
                    }
                    break;
                case "BrowserGeneral":
                    for (int i = 1; i < Enum.GetValues(typeof(GeneralBrowserFunctionVersionType)).Length; i++)
                    {
                        szVern = System.Enum.GetName(typeof(GeneralBrowserFunctionVersionType), i);
                        comboBoxFVVer.Items.Add(ReplaceStringToValue(szVern));
                        comboBoxFVVer1.Items.Add(ReplaceStringToValue(szVern));
                    }
                    break;
            }

            if (comboBoxFVVer.Items.Contains(szLastFV))
            {
                comboBoxFVVer.SelectedIndex = comboBoxFVVer.FindString(szLastFV);
            }
            else
            {
                comboBoxFVVer.SelectedIndex = 0;
            }
        }

        //Replace the string to value like v1_0 to 1.0 for easy readability in the UI.
        private string ReplaceStringToValue(string functionVersion)
        {
            functionVersion = functionVersion.Replace("v", "");
            functionVersion = functionVersion.Replace("_", ".");
            return functionVersion;
        }

        private void buttonSearch_Click(object sender, EventArgs e)
        {
            if (comboBoxFVOperator.Text == "Between" && double.Parse(comboBoxFVVer1.Text.Trim()) < double.Parse(comboBoxFVVer.Text.Trim()))
            {
                MessageBox.Show("Functionversion start value should be greater than functionversion end value.");
                this.DialogResult = DialogResult.Cancel;
            }
            else
            {
                this.settings.Application = checkBoxApp.Checked;
                this.settings.ApplicationName = textBoxApp.Text;
                this.settings.FunctionVersion = checkBoxFV.Checked;
                this.settings.FunctionVersionAppType = comboBoxFVType.Text;
                this.settings.FunctionVersionAppVersion = comboBoxFVVer.Text;
                this.settings.ProductName = checkBoxProductName.Checked;
                this.settings.ProductNameText = textBoxProductName.Text;
                this.settings.SSLSetting = checkBoxSSL.Checked;
                this.settings.SSLText = comboBoxSSL.Text;
                this.settings.FunctionVersionAppVersion1 = comboBoxFVVer1.Text;
                this.settings.FunctionVersionOperator = comboBoxFVOperator.Text;
                this.settings.ColorSetting = checkBoxColor.Checked;
                this.settings.ColorText = comboBoxColor.Text;
            }
            
            
        }

        private void checkBoxSSL_CheckedChanged(object sender, EventArgs e)
        {
            panelSSL.Enabled = checkBoxSSL.Checked;
         
        }

        private void comboBoxFVOperator_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboBoxFVOperator.Text == "Between")
            {
                //Show the From and To combobox for between operator
                comboBoxFVVer1.Visible = true;
                labelTo.Visible = true;
                labelFrom.Visible = true;
                if(comboBoxFVVer1.Items.Count>0)
                comboBoxFVVer1.SelectedIndex = comboBoxFVVer1.Items.Count - 1;
            }
            else
            {
                comboBoxFVVer1.Visible = false;
                labelTo.Visible = false;
                labelFrom.Visible = false;
            }
        }

        private void checkBoxColor_CheckedChanged(object sender, EventArgs e)
        {
            panelColor.Enabled = checkBoxColor.Checked;
        }

       
    }
}
